


export class GroupEditWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/groups/')}}" class="fa fa-chevron-circle-left"></a>
				
				<span ez-if="isNew == false">
					<a href="javascript:void(0);" [onclick]="widget.deleteGroup" class="fa fa-trash"></a>
				</span>
				
				<a href="javascript:void(0);" [onclick]="widget.saveGroup" class="fa fa-save"></a>
			</div>
			<h1>{{!group.userGroupId?'Nieuwe groep':'Bewerk groep'}}</h1>
		</div>
		
		
		<form id="frmGroup" action="{{appUrl('/service/groups.do')}}">
			<input type="hidden" name="a" value="save" />
			
			<input type="hidden" name="user_group_id" value="{{group.userGroupId}}" />
			
			<ez-text name="group_name" label="Groepsnaam" [value]="group.groupName"></ez-text>
			
			<ez-checkbox name="default_selected" label="{{_('Default selected')}}" [checked]="group.defaultSelected"></ez-checkbox>
			
			<ez-datetime-text label="Bewerkt op" hideempty="1" [value]="group.edited"></ez-datetime-text>
			
			<ez-datetime-text label="Aangemaakt op" hideempty="1" [value]="group.created"></ez-datetime-text>
		</form>
		
		
		<div ez-if="typeof group.userGroupId != 'undefined'">
			<hr/>
			<h2>Gekoppelde gebruikers</h2>
			<table class="table">
				<thead>
					<tr>
						<th>Gebruikersnaam</th>
						<th>E-mail</th>
						<th>Naam</th>
						<th></th>
					</th>
				</thead>
				<tbody ez-for="users" ez-item="u">
					<tr class="pointer" [onclick]="widget.gotoUser" data-user-id="{{u.userId}}">
						<td>{{u.username}}</td>
						<td>{{u.email}}</td>
						<td>{{u.firstname}} {{u.lastname}}</td>
						<td class="actions">
							<a href="{{ appUrl('/masterdata/users/edit/?id='+u.userId) }}" class="fa fa-pencil"></a>
						</td>
					</tr>
					<tbody ez-if="users.length == 0">
						<tr>
							<td class="no-results" colspan="100%">Geen resultaten</td>
						</tr>
					</tbody>
				</tbody>
			</table>
		</div>

	`;
	
	container = null;
	loading = false;
	
	ezTpl = null;
	group = {
		group_name: ''
	};
	users = [];
	
	init(e) {
		this.container = e;
		
		let id = getUrlParam('id');
		
		if (id) {
			this.loadGroup( id );
		}
		else {
			this.render();
		}
	}
	
	render() {
//		console.log( this.tpl );
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setObject('widget', this);
		this.ezTpl.setVar('group', this.group);
		this.ezTpl.setVar('users', this.users);
		
		this.ezTpl.setVar('isNew', this.group.userGroupId ? false : true);
		this.ezTpl.render();
	}
	
	
	deleteGroup() {
		showConfirmation( _('Delete group'), _('Are you sure to delete this group?'), async () => {
			showLoadingForm('#frmGroup');
			
			await postUrl( '/service/groups.do', {
				a: 'deleteGroup',
				userGroupId: this.group.userGroupId
			});
			
			gotoRoute( '/masterdata/groups/' );
		});
		
	}
	
	
	saveGroup() {
		if (this.loading) {
			return;
		}
		
		this.loading = true;
		
		postForm('#frmGroup').then(async function(e) {
			
			let json = await e.json();
			console.log( json );
			
			if (json.error) {
				// TODO: render errors
				formShowErrors( '#frmGroup', json );
				
			}
			else {
				// report succesfully saved
				reportUserMessage( 'Wijzigingen opgeslagen' );
				
				// reload data?
				this.loadGroup( json.group.userGroupId );
			}
			
			this.loading = false;
		}.bind(this)).catch(showErrorWidget);
		
	}
	
	
	loadGroup(groupId) {
		postUrl( '/service/groups.do', {
			a: 'view',
			groupId: groupId
		}).then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget(json);
			}
			
			this.group = json.userGroup;
			this.users = json.users;
			
			this.render();
			
			this.loading = false;
		}.bind(this) );
	}
	
	
	gotoUser( evt, tr ) {
		if (evt.target.nodeName == 'A') return;
		
		let uid = tr.dataset['userId'];
		
		gotoRoute( '/masterdata/users/edit/?id='+uid );
	}
	
	
}


